attribute vec2 coord_xz;
attribute float coord_y;
attribute vec3 normal;

#ifdef MULTI_TEX
attribute float factor1;
varying float f_factor1;
#endif

#ifdef MULTI_TEX2
attribute float factor2;
varying float f_factor2;
#endif

#ifdef MULTI_TEX3
attribute float factor3;
varying float f_factor3;
#endif

varying vec2 f_texcoord;
varying vec4 f_colorLightAmbient;
varying vec4 f_colorLightNonAmbient;

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
uniform mat4 v;
#endif

uniform mat4 mvp;
uniform mat3 m_3x3_inv_transp;
#ifdef USE_MODEL_MATRIX
uniform mat4 m;
#endif

#ifdef SPECULAR
uniform mat4 v_inv;
#endif

#ifdef SHADOW
	uniform int shadow_csm_index;
	uniform mat4 mvps_shadow[SHADOW_CSM_NUM];
	varying vec4 f_shadow_coord;

	#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
	varying vec4 f_shadow_coord_far;
	varying vec3 coord_world;
	#endif

	#ifdef SHADOW_SLOPE_BIAS
	varying float f_shadow_slope_bias;
	#endif
#endif

#ifndef TEX_COORD_SCALE
#define TEX_COORD_SCALE 1.0
#endif



void main(void)
{
	vec4 coord = vec4(coord_xz.x, coord_y, coord_xz.y, 1.0);
	//Position
	gl_Position = mvp * coord;
	#ifdef USE_MODEL_MATRIX
	vec4 positionWorld = m * coord;
	#endif

	//Towards Fragment Shader
	f_texcoord = vec2(coord.x*TEX_COORD_SCALE, coord.z*TEX_COORD_SCALE);


	//Lighting
	vec3 normalDirection = getNormalDirection(m_3x3_inv_transp, normal);
	vec3 lightDirection = getLightDirection(currentLight.position);

	vec3 diffuseReflection = getDiffuseReflection(currentLight.diffuse, currentMaterial.diffuse, normalDirection, lightDirection);

	vec3 ambientLighting = getAmbientLighting(currentLight.ambient, currentMaterial.ambient);

	f_colorLightAmbient = vec4(ambientLighting, 1.0);
	f_colorLightNonAmbient = vec4(diffuseReflection, 1.0);

#ifdef SPECULAR
	vec3 viewDirection = getViewDirection(v_inv, positionWorld);
	vec3 specularReflection = getSpecularReflection(currentLight.specular, currentMaterial.specular, currentMaterial.shininess,
													 normalDirection, lightDirection, viewDirection);
	f_colorLightNonAmbient += vec4(specularReflection, 1.0);
#endif

#ifdef SHADOW
	#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
	f_shadow_coord = mvps_shadow[SHADOW_INDEX_CLOSE] * coord;
	f_shadow_coord_far = mvps_shadow[SHADOW_INDEX_FAR] * coord;
	coord_world = positionWorld.xyz;
	#else
	f_shadow_coord = mvps_shadow[shadow_csm_index] * coord;
	#endif

	#ifdef SHADOW_SLOPE_BIAS
	f_shadow_slope_bias = calcShadowSlopeBiasFactor(normalDirection, lightDirection);
	#endif
#endif

#ifdef MULTI_TEX
	f_factor1 = factor1;
#endif

#ifdef MULTI_TEX2
	f_factor2 = factor2;
#endif

#ifdef MULTI_TEX3
	f_factor3 = factor3;
#endif

#ifdef FOG
	f_fogFactor = getFogFactor(v, positionWorld);
	f_fogFactorGround = getFogFactorGround(f_fogFactor, positionWorld);
#endif
}

